<?php

namespace app\controllers;

use Yii;
use app\models\Report;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\User;
use app\models\Role;


class ReportController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['customer-sales', 'stock-wise-sales', 'draw-wise', 'barcode', 'result', 'terminal-balance', 'active-terminal', 'stocklist-balance'],
                'rules' => [
                    [
                        'actions' => ['customer-sales', 'stock-wise-sales', 'draw-wise', 'barcode', 'result', 'terminal-balance', 'active-terminal', 'stocklist-balance'],
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function ($rule, $action) {
                            if ($action->id == 'customer-sales') {
                                return Yii::$app->user->can('view customer sales reports');
                            } else if ($action->id == 'stock-wise-sales') {
                                return Yii::$app->user->can('stocklist sales reports');
                            } else if ($action->id == 'draw-wise') {
                                return Yii::$app->user->can('today draw reports');
                            } else if ($action->id == 'barcode') {
                                return Yii::$app->user->can('barcode reports');
                            } else if ($action->id == 'result') {
                                return Yii::$app->user->can('result reports');
                            } else if ($action->id == 'terminal-balance') {
                                return Yii::$app->user->can('customer balance reports');
                            } else if ($action->id == 'active-terminal') {
                                return Yii::$app->user->can('online terminals reports');
                            } else if ($action->id == 'stocklist-balance') {
                                return Yii::$app->user->can('stocklist balance reports');
                            }
                        }
                    ],
                ],
            ]
        ];
    }

    public function actionCustomerSales()
    {
        $report_type = 'terminal_date_wise';
        $from_date = '';
        $to_date = '';

        $final_data = [
            'aggregate' => [],
            'reports' => []
        ];
        if ($this->request->isPost) {
            $data = [];
            $report_type = $this->request->post('report_type');
            $from_date = $this->request->post('from_date');
            $to_date = $this->request->post('to_date');

            $db = Yii::$app->db;

            // find or each terminalfirst
            if (Yii::$app->session->get('role') == Role::ROLE_STOCK_LIST) {
                $userId =  Yii::$app->user->id;
                $terminal_id_array = Yii::$app->db->createCommand("SELECT terminal_id FROM stocklist_terminal WHERE stocklist_id=$userId")->queryAll();
                $terminal_id_array = array_column($terminal_id_array, 'terminal_id');
                $terminal_id_array = join(',', $terminal_id_array);
                $sql = "SELECT u.id, u.code, u.name AS terminal_name
            FROM users AS u
            INNER JOIN roles AS r ON r.id = u.role_id
            WHERE u.id IN ($terminal_id_array) AND r.name = :role_name";
            } else {
                $sql = "SELECT u.id, u.code, u.name AS terminal_name
            FROM users AS u
            INNER JOIN roles AS r ON r.id = u.role_id
            WHERE r.name = :role_name";
            }
            /*  $sql = "SELECT u.id, u.code, u.name AS terminal_name
            FROM users AS u
            INNER JOIN roles AS r ON r.id = u.role_id
            WHERE r.name = :role_name"; */
            $terminals = $db->createCommand($sql, [':role_name' => 'terminal'])->queryAll();

            $final_amount = 0;
            $final_prize = 0;
            $final_total = 0;
            $final_commission_amount = 0;
            $final_net_payable = 0;

            if ($report_type == 'terminal_date_wise') {
                foreach ($terminals as $terminal) {
                    $periods = new \DatePeriod(
                        new \DateTime($from_date),
                        new \DateInterval('P1D'),
                        (new \DateTime($to_date))->modify('+ 1 day')
                    );

                    $date_reports = [];
                    foreach ($periods as $period) {
                        $sql = "SELECT u.code, IFNULL(SUM(o.grand_total), 0) AS amount, IFNULL(SUM(o.prize_amount), 0) AS prize
                        FROM orders AS o
                        INNER JOIN users AS u ON u.id = o.terminal_id
                        WHERE o.terminal_id = :terminal_id AND DATE(o.created_at) = :date AND o.is_canceled = :is_canceled
                        HAVING amount > 0";

                        $dateReports = $db->createCommand($sql, [
                            ':terminal_id' => $terminal['id'],
                            ':date' =>  $period->format('Y-m-d'),
                            ':is_canceled' => 0
                        ])->queryOne();

                        if ($dateReports !== false) {
                            $dateReports['date'] = $period->format('d-m-Y');
                            $dateReports['total'] = floatval($dateReports['amount']) - floatval($dateReports['prize']);
                            $dateReports['commission_amount'] = round(floatval($dateReports['amount']) * 0.06, 2);
                            $dateReports['net_payable'] =  $dateReports['total'] - $dateReports['commission_amount'];

                            $date_reports[] = $dateReports;
                        }
                    }

                    $amount = array_sum(array_column($date_reports, 'amount'));
                    $prize = array_sum(array_column($date_reports, 'prize'));
                    $total = array_sum(array_column($date_reports, 'total'));
                    $commission_amount = array_sum(array_column($date_reports, 'commission_amount'));
                    $net_payable = array_sum(array_column($date_reports, 'net_payable'));

                    $final_amount += $amount;
                    $final_prize += $prize;
                    $final_total += $total;
                    $final_commission_amount += $commission_amount;
                    $final_net_payable += $net_payable;

                    $data[] = [
                        'terminal_code' => $terminal['code'],
                        'date_reports' => $date_reports,
                        'total' => [
                            'amount' => array_sum(array_column($date_reports, 'amount')),
                            'prize' => array_sum(array_column($date_reports, 'prize')),
                            'total' => array_sum(array_column($date_reports, 'total')),
                            'commission_amount' => array_sum(array_column($date_reports, 'commission_amount')),
                            'net_payable' => array_sum(array_column($date_reports, 'net_payable'))
                        ]
                    ];
                }

                $final_data = [
                    'aggregate' => [
                        'final_amount' => $final_amount,
                        'final_prize' => $final_prize,
                        'final_total' => $final_total,
                        'final_commission_amount' => $final_commission_amount,
                        'final_net_payable' => $final_net_payable
                    ],
                    'reports' => $data
                ];
            } else {
                foreach ($terminals as &$terminal) {
                    // find retailer name for this terminal
                    $sql = "SELECT u.name AS retailer_name
                    FROM users AS u
                    INNER JOIN stocklist_terminal AS s_t ON s_t.stocklist_id = u.id
                    WHERE s_t.terminal_id = :terminal_id";

                    $retailerName = $db->createCommand($sql, [':terminal_id' => $terminal['id']])->queryScalar();
                    $terminal['retailer'] = $retailerName;

                    $sql = "SELECT u.code, IFNULL(SUM(o.grand_total), 0) AS amount, IFNULL(SUM(o.prize_amount), 0) AS prize, IFNULL(SUM(o.total_quantity), 0) AS total_quantity
                    FROM orders AS o
                    INNER JOIN users AS u ON u.id = o.terminal_id
                    WHERE o.terminal_id = :terminal_id AND DATE(o.created_at) BETWEEN :from_date AND :to_date AND o.is_canceled = :is_canceled";

                    $terminalData = $db->createCommand($sql, [
                        ':terminal_id' => $terminal['id'],
                        ':from_date' => $from_date,
                        ':to_date' => $to_date,
                        ':is_canceled' => 0
                    ])->queryOne();

                    $terminal['total_quantity'] = $terminalData['total_quantity'];
                    $terminal['amount'] = $terminalData['amount'];
                    $terminal['prize'] = $terminalData['prize'];
                    $terminal['total'] = floatval($terminalData['amount']) - floatval($terminalData['prize']);
                    $terminal['commission_amount'] = round(floatval($terminal['total']) * 0.06, 2);
                    $terminal['net_payable'] = $terminal['total'] - $terminal['commission_amount'];
                }

                $final_terminals = $terminals;

                $final_terminals = array_filter($terminals, function ($item) {
                    if ($item['amount'] > 0) {
                        return $item;
                    }
                });

                $final_data = [
                    'aggregate' => [
                        'final_total_quantity' => array_sum(array_column($terminals, 'total_quantity')),
                        'final_amount' => array_sum(array_column($terminals, 'amount')),
                        'final_prize' => array_sum(array_column($terminals, 'prize')),
                        'final_total' => array_sum(array_column($terminals, 'total')),
                        'final_commission_amount' => array_sum(array_column($terminals, 'commission_amount')),
                        'final_net_payable' => array_sum(array_column($terminals, 'net_payable'))
                    ],
                    'reports' => $final_terminals
                ];
            }
        }

        return $this->render('customer-sales', [
            'report_type' => $report_type,
            'reports' => $final_data,
            'from_date' => $from_date,
            'to_date' => $to_date
        ]);
    }

    public function actionStockWiseSales()
    {
        $from_date = '';
        $to_date = '';
        $reports = [];
        if ($this->request->isPost) {
            $from_date = $this->request->post('from_date');
            $to_date = $this->request->post('to_date');
            $reports = Report::getStocklistSummry($from_date, $to_date);
        }

        return $this->render('stock-wise', [
            'reports' => $reports,
            'from_date' => $from_date,
            'to_date' => $to_date
        ]);
    }

    public function actionDrawWise()
    {
        return $this->render('draw-wise', [
            'reports' => Report::getTodayDrawWiseReport()
        ]);
    }

    public function actionBarcode()
    {
        $db = Yii::$app->db;

        // barcode users
        $terminalUsers = User::getAllTerminalUsers();

        // get all sessions
        $sql = "SELECT session_id FROM results WHERE DATE(published_on) = CURDATE()";
        $sessionList = $db->createCommand($sql)->queryAll();

        foreach ($sessionList as &$list) {
            $dateTime = new \DateTime();
            $dateTime->setTimestamp($list['session_id']);
            $list['session_time'] = $dateTime->format('h:i A');
        }

        // now push current session in the session's list
        $sql = "SELECT current_session_id FROM session WHERE id = 1";
        $current_session_id = $db->createCommand($sql)->queryScalar();

        $dateTime = new \DateTime();
        $dateTime->setTimestamp(intval($current_session_id));
        $sessionList[] = [
            'session_id' => $current_session_id,
            'session_time' => $dateTime->format('h:i A')
        ];

        $barcodeReports = [];
        $selected_date = date('Y-m-d');
        $selected_terminal_id = '';
        $selected_sesssion_id = '';
        $total_quantity = 0;
        $total_amount = 0;
        $total_prize_amount = 0;
        $net_balance = 0;

        if ($this->request->isPost) {
            $date = $this->request->post('date');
            $terminal_id = $this->request->post('terminal_id');
            $sesssion_id = $this->request->post('session_id');

            $where_clause = "WHERE 1";
            $where_clause_arr = [];

            if (!is_null($date) && $date != '') {
                $where_clause_arr[] = "DATE(orders.created_at) = '" . $date . "'";
                $selected_date = $date;
            }

            if (!is_null($terminal_id) && $terminal_id != '') {
                $where_clause_arr[] = "orders.terminal_id = " . $terminal_id;
                $selected_terminal_id = $terminal_id;
            }

            if (!is_null($sesssion_id) && $sesssion_id != '') {
                $where_clause_arr[] = 'orders.session_id = ' . $sesssion_id;
                $selected_sesssion_id = $sesssion_id;
            }

            $where_clause_arr[] = 'orders.is_canceled = 0';

            if (!empty($where_clause_arr)) {
                $where_clause_str = implode(' AND ', $where_clause_arr);
                $where_clause .= ' AND (' . $where_clause_str . ')';

                $sql = "SELECT orders.*, users.code AS terminal_code
                FROM orders
                INNER JOIN users ON users.id = orders.terminal_id
                $where_clause";

                $barcodeReports = $db->createCommand($sql)->queryAll();

                $sl_no = 1;
                foreach ($barcodeReports as &$report) {
                    // get particulars

                    // find if prize exist for this order or not
                    $sql = "SELECT order_items.number
                    FROM order_items
                    JOIN orders ON orders.id = order_items.order_id
                    JOIN results ON results.session_id = orders.session_id AND results.number = order_items.number
                    WHERE orders.id = :order_id AND orders.is_canceled = 0";

                    $checkPrize = $db->createCommand($sql, [':order_id' => $report['id']])->queryOne();

                    $report['is_prize_available'] = 0;
                    if ($checkPrize !== false) {
                        $report['is_prize_available'] = 1;
                    }

                    $dateTime = new \DateTime();
                    $dateTime->setTimestamp($report['session_id']);

                    $report['draw_time'] = $dateTime->format('h:i A');

                    $ticketTime = new \DateTime($report['created_at']);
                    $report['ticket_time'] = $ticketTime->format('h:i:s A');

                    $sql = "SELECT number, quantity FROM order_items WHERE order_id = :order_id";
                    $order_items = $db->createCommand($sql, [':order_id' => $report['id']])->queryAll();
                    $particular = '';
                    foreach ($order_items as $item) {
                        $particular .= str_pad($item['number'], '2', '0', STR_PAD_LEFT) . '-' . $item['quantity'] . '; ';
                    }
                    $report['particular'] = $particular;


                    $total_amount += floatval($report['grand_total']);
                    $total_quantity += intval($report['total_quantity']);
                    $total_prize_amount += floatval($report['prize_amount']);

                    $report['sl_no'] = $sl_no++;
                    $report['game_name'] = 'Bigstar';
                }

                $net_balance = $total_amount - $total_prize_amount;
            }
        }

        return $this->render('barcode', [
            'barcodeReports' => $barcodeReports,
            'terminalUsers' => $terminalUsers,
            'sessionList' => $sessionList,
            'selected_date' => $selected_date,
            'selected_terminal_id' => $selected_terminal_id,
            'selected_sesssion_id' => $selected_sesssion_id,
            'total_quantity' => $total_quantity,
            'total_amount' => $total_amount,
            'total_prize_amount' => $total_prize_amount,
            'net_balance' => $net_balance
        ]);
    }

    public function actionResult()
    {
        $db = Yii::$app->db;

        $sql = "SELECT * FROM settings WHERE name = :name";
        $settingsData = $db->createCommand($sql, [':name' => 'payout-settings'])->queryOne();
        $settingsValue = unserialize($settingsData['value']);

        $choosenDate = '';
        $reports = [];

        if ($this->request->isPost) {
            $choosenDate = $this->request->post('date');

            $sql = "SELECT * FROM results WHERE DATE(published_on) = :date";
            $data = $db->createCommand($sql, [':date' => $choosenDate])->queryAll();

            $i = 1;
            foreach ($data as &$report) {
                $report['sl_no'] = $i++;
                $report['draw_name'] = $settingsValue['game_name'];
                $report['number'] = str_pad($report['number'], '2', '0', STR_PAD_LEFT);

                $dateTime = new \DateTime($choosenDate);

                $report['draw_date'] = $dateTime->format('d-m-Y');

                $dateTime = new \DateTime();
                $dateTime->setTimestamp(intval($report['session_id']));

                $report['draw_time'] = $dateTime->format('h:i A');
                $report['mrp'] =  $settingsValue['mrp'];
            }

            $reports = $data;
        }

        return $this->render('result', [
            'reports' => $reports,
            'gameSettings' =>  $settingsValue,
            'choosenDate' => $choosenDate
        ]);
    }

    public function actionTerminalBalance()
    {
        return $this->render('terminal-balance', [
            'terminalUsers' => Report::getAllTerminalBalance()
        ]);
    }

    public function actionActiveTerminal()
    {
        return $this->render('active-terminal', [
            'activeTerminals' => Report::getAllActiveTerminals()
        ]);
    }

    public function actionStocklistBalance()
    {
        return $this->render('stocklist-balance', [
            'stocklistUsers' => Report::getAllStockListBalance()
        ]);
    }
}
