<?php

namespace app\models;


use yii\base\Model;

class AssignStocklistTerminalForm extends Model
{
    public $terminal_id;
    public $stocklist_id;

    public function rules()
    {
        return [
            [ ['terminal_id', 'stocklist_id'], 'required' ],
            [ 'terminal_id', 'validateTerminalId' ]
        ];
    }

    public function attributeLabels()
    {
        return [
            'terminal_id' => 'Terminal',
            'stocklist_id' => 'Stocklist'
        ];
    }

    public function validateTerminalId($attribute, $params)
    {
        $terminalCheck = StocklistTerminal::findOne([ 'terminal_id' => $this->terminal_id ]);
        if( !is_null($terminalCheck) ) {
            $this->addError($attribute, 'This terminal is already assigned to a stocklist');
        }
    }

    public function assign()
    {
        $model = new StocklistTerminal();
        $model->stocklist_id = $this->stocklist_id;
        $model->terminal_id = $this->terminal_id;

        return $model->insert(false);
    }
}