<?php

namespace app\models;

use Yii;
use yii\base\Model;

class ChangePasswordForm extends Model
{
    public $username;
    public $current_password;
    public $new_password;
    public $confirm_password;

    private $_user = false;

    public function rules()
    {
        return [
            [ ['username', 'current_password', 'new_password', 'confirm_password'], 'required'],
            ['new_password', 'compare', 'compareAttribute' => 'confirm_password'],
            ['username', 'checkUserNameExist'],
            ['current_password', 'checkCurrentPassword']
        ];
    }

    public function checkCurrentPassword($attribute, $params)
    {
        $user = $this->getUser();
        if($user) {
            if($user->validatePassword($this->current_password) === false) {
                $this->addError($attribute, 'Current password is wrong');
            }
        }
    }

    public function checkUserNameExist($attribute, $params)
    {
        $user = $this->getUser();

        if( !$user ) {
            $this->addError($attribute, 'Username does not exit');
        }
    }

    private function getUser()
    {
        if ($this->_user === false) {
            $this->_user = User::findByUsername($this->username);
        }

        return $this->_user;
    }

    public function updatePassword()
    {
        $user = $this->getUser();
        $user->generatePasswordHash($this->new_password);
        
        return $user->save(false);
    }
}