<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

class Role extends ActiveRecord
{
    const ROLE_SUPER_ADMIN = 'super_admin';
    const ROLE_STOCK_LIST = 'stock_list';
    const ROLE_TERMINAL = 'terminal';

    const DEFUALT_ROLES = [
        self::ROLE_SUPER_ADMIN,
        self::ROLE_STOCK_LIST,
        self::ROLE_TERMINAL
    ];

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'roles';
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
        ];
    }

    /**
     * Gets query for [[Users]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUsers()
    {
        return $this->hasMany(User::class, ['role_id' => 'id']);
    }

    public static function getPermissions($role_id)
    {
        $sql = "SELECT CONCAT(p.name, ' ', m.name) AS permissions 
        FROM permissions AS p 
        INNER JOIN modules AS m ON m.id = p.module_id
        INNER JOIN role_permissions AS r_p ON r_p.permission_id = p.id
        INNER JOIN roles AS r ON r.id = r_p.role_id
        WHERE r.id = :role_id
        ORDER BY m.name DESC";

        $perms = Yii::$app->db->createCommand($sql, [':role_id' => $role_id])->queryAll();

        if (!empty($perms)) {
            return array_column($perms, 'permissions');
        }

        return $perms;
    }

    public static function getPermissionIds($role_id)
    {
        $sql = "SELECT p.id AS permissions 
        FROM permissions AS p 
        INNER JOIN modules AS m ON m.id = p.module_id
        INNER JOIN role_permissions AS r_p ON r_p.permission_id = p.id
        INNER JOIN roles AS r ON r.id = r_p.role_id
        WHERE r.id = :role_id
        ORDER BY m.name DESC";

        $perms = Yii::$app->db->createCommand($sql, [':role_id' => $role_id])->queryAll();

        if (!empty($perms)) {
            return array_column($perms, 'permissions');
        }

        return $perms;
    }

    /**
     * Get all permissson
     * 
     * @return array 
     */
    public static function getAllModulePermissions()
    {
        $modules = Yii::$app->db->createCommand("SELECT * FROM modules")->queryAll();
        if (!empty($modules)) {
            foreach ($modules as &$module) {
                $module['perms'] = Yii::$app->db->createCommand("SELECT * FROM permissions 
                WHERE module_id=:module_id ORDER BY name")
                    ->bindValue(':module_id', $module['id'])
                    ->queryAll();
            }
        }

        return  $modules;
    }
}
