<?php

namespace app\models\settings;

use app\models\BaseSettingsModel;

class ManualResultTimeSettings extends BaseSettingsModel
{
    protected $settings_name = 'manual-result-time-settings';

    public $time_limit;

    public function rules()
    {
        return [
            [ 'time_limit', 'required'],
            ['time_limit', 'compare', 'compareValue' => 270, 'operator' => '<=', 'type' => 'number']
        ];
    }

    public function getSaveableAttr()
    {
        return [
            'time_limit' => $this->time_limit
        ];
    }
}