CREATE TABLE roles(
    id INT NOT NULL AUTO_INCREMENT,
    name varchar(255) NOT NULL,

    PRIMARY KEY (id),
    CONSTRAINT uniq_name_roles UNIQUE KEY (name)
);

ALTER TABLE <userTable> ADD role_id INT DEFAULT NULL;

ALTER TABLE <userTable>
ADD CONSTRAINT fk_role_id_<userTable> FOREIGN KEY (role_id) REFERENCES roles(id)
        ON DELETE SET NULL
        ON UPDATE NO ACTION;

CREATE TABLE modules(
    id INT NOT NULL AUTO_INCREMENT,
    name varchar(255) NOT NULL,

    PRIMARY KEY(id),
    CONSTRAINT uniq_name_modules UNIQUE KEY (name) 
);

CREATE TABLE permissions(
    id INT NOT NULL AUTO_INCREMENT,
    module_id INT,
    name varchar(255) NOT NULL,

    PRIMARY KEY(id),
    CONSTRAINT uniq_module_id_name_permissions UNIQUE KEY (module_id,name),
    CONSTRAINT fk_module_id_permissions FOREIGN KEY (module_id) REFERENCES modules(id)
        ON DELETE CASCADE
        ON UPDATE NO ACTION
);

CREATE TABLE role_permissions(
    id INT NOT NULL AUTO_INCREMENT,
    role_id INT,
    permission_id INT,

    PRIMARY KEY(id),
    CONSTRAINT uniq_role_id_permission_id_role_permissions UNIQUE KEY (role_id,permission_id),

    CONSTRAINT fk_role_id_role_permissions FOREIGN KEY(role_id) REFERENCES roles(id)
        ON DELETE CASCADE
        ON UPDATE NO ACTION,

    CONSTRAINT fk_permission_id_role_permissions FOREIGN KEY (permission_id) REFERENCES permissions(id)
        ON DELETE CASCADE
        ON UPDATE NO ACTION
);