<?php

namespace app\controllers;

use yii\web\Controller;
use yii\filters\AccessControl;

use Yii;
use app\models\User;

class BlockController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['terminal', 'stocklist'],
                'rules' => [
                    [
                        'actions' => ['terminal', 'stocklist'],
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function ($rule, $action) {
                            if ($action->id == 'terminal') {
                                return  Yii::$app->user->can('terminal blocks');
                            } else if ($action->id == 'stocklist') {
                                return  Yii::$app->user->can('stocklist blocks');
                            }
                        }
                    ]
                ],
            ]
        ];
    }

    public function actionTerminal()
    {
        if ($this->request->isPost) {
            $terminal_user_id = $this->request->post('terminal_user_id');
            $status = $this->request->post('is_blocked');
            if (empty($terminal_user_id)) {
                Yii::$app->session->setFlash('error', 'Please select a terminal');
            } else {
                $user = User::findOne($terminal_user_id);
                if ($user->is_active == 1) {
                    $options = [
                        'cluster' => $_ENV['PUSHER_APP_CLUSTER'],
                        'useTLS' => false
                    ];
                    $pusher = new \Pusher\Pusher($_ENV['PUSHER_KEY'], $_ENV['PUSHER_SECRET'], $_ENV['PUSHER_APP_ID'], $options);
                    $pusher->trigger('game', 'blockuser', [
                        'user_code' => $user->code
                    ]);
                }
                $user->is_active = ($status == 'yes') ? '0' : '1';
                $user->save(false);

                if ($status == 'yes') {
                    Yii::$app->session->setFlash('success', 'Terminal blocked successfully');
                } else {
                    Yii::$app->session->setFlash('success', 'Terminal unblocked successfully');
                }

                return $this->redirect(['dashboard/index']);
            }
        }

        return $this->render('terminal', [
            'terminalUsers' => User::getAllTerminalUsers()
        ]);
    }

    public function actionStocklist()
    {
        if ($this->request->isPost) {
            $stocklist_user_id = $this->request->post('stocklist_user_id');
            $status = $this->request->post('is_blocked');
            if (empty($stocklist_user_id)) {
                Yii::$app->session->setFlash('error', 'Please select a stocklist');
            } else {
                $user = User::findOne($stocklist_user_id);
                $user->is_active = $this->request->post('is_blocked');
                $user->save(false);

                if ($status == 'yes') {
                    Yii::$app->session->setFlash('success', 'Stocklist blocked successfully');
                } else {
                    Yii::$app->session->setFlash('success', 'Stocklist unblocked successfully');
                }

                return $this->redirect(['dashboard/index']);
            }
        }

        return $this->render('stocklist', [
            'stockListUsers' => User::getAllStockListUsers()
        ]);
    }
}
