<?php

namespace app\models;

use Yii;
use yii\base\Model;
use app\models\User;
use app\models\Role;

class StockListForm extends Model
{
    public $code;
    public $name;
    public $loginName;
    public $password;
    public $address;
    public $city;
    public $phone_number_one;
    public $phone_number_two;

    const SCENARIO_ADD = 'scenario_add';
    const SCENARIO_UPDATE = 'scenario_update'; 

    public function rules()
    {
        return [
            [ ['code', 'name', 'loginName', 'password', 'address', 'city', 'phone_number_one'], 'required', 'on' => self::SCENARIO_ADD ],
            [ ['code', 'name', 'loginName', 'address', 'city', 'phone_number_one'], 'required', 'on' => self::SCENARIO_UPDATE ],
            [[ 'phone_number_two' ], 'safe']
        ];
    }

    public function scenarios()
    {
        $scenarios = parent::scenarios();
        $scenarios[self::SCENARIO_ADD] = ['code', 'name', 'loginName', 'password', 'address', 'city', 'phone_number_one', 'phone_number_two'];
        $scenarios[self::SCENARIO_UPDATE] = ['code', 'name', 'loginName', 'address', 'city', 'phone_number_one', 'phone_number_two'];

        return $scenarios;
    }

    public function init()
    {
        parent::init();
        if( $this->scenario == self::SCENARIO_ADD ) {
      
            $sql = "SELECT COUNT(*) AS total 
            FROM users
            JOIN roles ON roles.id = users.role_id
            WHERE roles.name = :role_name";

            $lastId = Yii::$app->db
                ->createCommand($sql, [ ':role_name' => 'stock_list' ])
                ->queryScalar();

            $lastId = (int) $lastId + 1;

            $this->code = 'ST' . str_pad((string)$lastId, 5, "0", STR_PAD_LEFT);
            $this->loginName = uniqid('stock_');
        }
    }

    public function create()
    {
        $user = new User();
        $user->code = $this->code;
        $user->name = $this->name;
        $user->role = Role::ROLE_STOCK_LIST;
        $user->username = $this->loginName;
        $user->password = $this->password;
        $user->address = $this->address;
        $user->city = $this->city;
        $user->phone_one = $this->phone_number_one;
        $user->phone_two = $this->phone_number_two;
        $user->created_at = date('Y-m-d H:i:s');

        return $user->save();
    }

    public function update()
    {
        $user = User::findOne(['username' => $this->loginName]);

        $user->name = $this->name;
        $user->address = $this->address;
        $user->city = $this->city;
        $user->phone_one = $this->phone_number_one;
        $user->phone_two = $this->phone_number_two;

        if( !empty($_POST['StockListForm']['password']) ) {
            $user->generatePasswordHash($_POST['StockListForm']['password']);
            $user->original_password = $_POST['StockListForm']['password'];
        }
        
        return $user->save();
    }
}