<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "stocklist_terminal".
 *
 * @property int $id
 * @property int|null $stocklist_id
 * @property int|null $terminal_id
 *
 * @property Users $stocklist
 * @property Users $terminal
 */
class StocklistTerminal extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'stocklist_terminal';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['stocklist_id', 'terminal_id'], 'required'],
            [['stocklist_id', 'terminal_id'], 'integer'],
            [['stocklist_id', 'terminal_id'], 'unique', 'targetAttribute' => ['stocklist_id', 'terminal_id']],
            [['stocklist_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['stocklist_id' => 'id']],
            [['terminal_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['terminal_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'stocklist_id' => 'Stocklist',
            'terminal_id' => 'Terminal',
        ];
    }

    /**
     * Gets query for [[Stocklist]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getStocklist()
    {
        return $this->hasOne(User::class, ['id' => 'stocklist_id']);
    }

    /**
     * Gets query for [[Terminal]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getTerminal()
    {
        return $this->hasOne(User::class, ['id' => 'terminal_id']);
    }
}
