<?php

namespace app\models\settings;

use app\models\BaseSettingsModel;

class PayoutSettings extends BaseSettingsModel
{
    protected $settings_name = 'payout-settings';

    public $game_name;
    public $mrp;
    public $payout;

    public function init()
    {
        parent::init();
        if(!$this->game_name) {
            $this->game_name = '2DIGIT';
        }

        if(!$this->mrp) {
            $this->mrp = 2;
        }
    }

    public function rules()
    {
        return [
            [ ['game_name', 'mrp', 'payout'], 'required' ]
        ];
    }

    public function getSaveableAttr()
    {
        return [
            'game_name' => $this->game_name,
            'mrp' => $this->mrp,
            'payout' => $this->payout
        ];
    }
}